Script.Load( "Data\\Script\\MapTools\\Main.lua" )
------------------------------------------------------------------------------
function InitDiplomacy()
	SetFriendly(1,2)
	Logic.SetShareExplorationWithPlayerFlag(1,2,1)
		
	SetHostile(1,4)
	SetHostile(2,4)
	SetHostile(1,5)

	end
------------------------------------------------------------------------------
function InitResources()
	
	Logic.AddToPlayersGlobalResource(1,ResourceType.GoldRaw,1000)
	Logic.AddToPlayersGlobalResource(1,ResourceType.ClayRaw,1000)
	Logic.AddToPlayersGlobalResource(1,ResourceType.StoneRaw,1000)
	Logic.AddToPlayersGlobalResource(1,ResourceType.SulfurRaw,1000)
	Logic.AddToPlayersGlobalResource(1,ResourceType.IronRaw,1000)
	Logic.AddToPlayersGlobalResource(1,ResourceType.WoodRaw,1000)
    end
------------------------------------------------------------------------------
function InitTechnologies()
	ForbidTechnology(Technologies.GT_Matchlock)
	ForbidTechnology(Technologies.GT_PulledBarrel)
	
	ResearchTechnology(Technologies.GT_Mercenaries)
	ResearchTechnology(Technologies.GT_StandingArmy)
	ResearchTechnology(Technologies.GT_Tactics)
	
	ResearchTechnology(Technologies.GT_Construction)
	
	ResearchTechnology(Technologies.GT_Alchemy)
	
	ResearchTechnology(Technologies.GT_Literacy)
	
	ResearchTechnology(Technologies.GT_Mathematics)
	ResearchTechnology(Technologies.GT_Binocular)
end
------------------------------------------------------------------------------
function InitWeatherGfxSets()
	if FinalAttackComming ~= true then
		Display.SetRenderUseGfxSets(1)
		
		Display.GfxSetSetSkyBox(1, 0.0, 1.0, "YSkyBox03")
		Display.GfxSetSetSnowStatus(1, 0, 1.0, 0)
		Display.GfxSetSetSnowEffectStatus(1, 0.0, 0.8, 0)
		Display.GfxSetSetFogParams(1, 0.0, 1.0, 1, 170,172,172, 7000,30000)
		Display.GfxSetSetLightParams(1,  0.0, 1.0, 40, -15, -25,  167,167,209,  255,226,226)
		
		 Display.GfxSetSetSkyBox(3, 0.0, 1.0, "YSkyBox01")
		Display.GfxSetSetSnowStatus(3, 0, 1.0, 1)
		Display.GfxSetSetSnowEffectStatus(3, 0.0, 0.8, 1)
		Display.GfxSetSetFogParams(3, 0.0, 1.0, 1, 152,172,182, 4000,30000)
		Display.GfxSetSetLightParams(3,  0.0, 1.0,  40, -15, -25,  100,110,110, 250,250,250)
		
		Display.GfxSetSetSkyBox(2, 0.0, 1.0, "YSkyBox04")
		 Display.GfxSetSetRainEffectStatus(2, 0.0, 1.0, 1)
		 Display.GfxSetSetSnowStatus(2, 0, 1.0, 0)
		 Display.GfxSetSetSnowEffectStatus(2, 0.0, 0.8, 0)
		 Display.GfxSetSetFogParams(2, 0.0, 1.0, 1, 102,132,142, 3500,30000)
		 Display.GfxSetSetLightParams(2,  0.0, 1.0, 40, -15, -25,  120,110,110,  255,254,230)
 
	else
		Display.SetRenderUseGfxSets(1)
		
		Display.GfxSetSetSkyBox(1, 0.0, 1.0, "YSkyBox03")
		Display.GfxSetSetSnowStatus(1, 0, 1.0, 0)
		Display.GfxSetSetSnowEffectStatus(1, 0.0, 0.8, 0)
		Display.GfxSetSetFogParams(1, 0.0, 1.0, 1, 170,172,172, 7000,30000)
		Display.GfxSetSetLightParams(1,  0.0, 1.0, 40, -15, -25,  167,167,209,  255,226,226)
		
		Display.GfxSetSetSkyBox(2, 0.0, 1.0, "YSkyBox04")
		Display.GfxSetSetRainEffectStatus(2, 0.0, 1.0, 1)
		Display.GfxSetSetSnowStatus(2, 0, 1.0, 0)
		Display.GfxSetSetSnowEffectStatus(2, 0.0, 0.8, 0)
		Display.GfxSetSetFogParams( 2, 0.0, 1.0, 1, 0, 140, 80, 0,30000)
		Display.GfxSetSetLightParams( 2,  0.0, 1.0, 40, -15, -50, 120,130,255, 255,254,230)
		
		Display.GfxSetSetSkyBox(3, 0.0, 1.0, "YSkyBox01")
		Display.GfxSetSetSnowStatus(3, 0, 1.0, 1)
		Display.GfxSetSetSnowEffectStatus(3, 0.0, 0.8, 1)
		Display.GfxSetSetFogParams(3, 0.0, 1.0, 1, 152,172,182, 4000,30000)
		Display.GfxSetSetLightParams(3,  0.0, 1.0,  40, -15, -25,  100,110,110, 250,250,250)
		
	end
    end
------------------------------------------------------------------------------
function InitWeather()
	AddPeriodicSummer(10)
end

------------------------------------------------------------------------------
function InitPlayerColorMapping()

	Display.SetPlayerColorMapping(1,PLAYER_COLOR)
	Display.SetPlayerColorMapping(2,FRIENDLY_COLOR1)
	
	if CitywallsPlayercolor ~= true then
		Display.SetPlayerColorMapping(3,FRIENDLY_COLOR1)
	else
		Display.SetPlayerColorMapping(3,PLAYER_COLOR)
	end
		Display.SetPlayerColorMapping(4,EVIL_GOVERNOR_COLOR)

		Display.SetPlayerColorMapping(5,NEPHILIM_COLOR)
		Display.SetPlayerColorMapping(6,FRIENDLY_COLOR1)
	
end
	
------------------------------------------------------------------------------
function FirstMapAction()

	-- load scripts
	IncludeLocals("BriefingTable")
	
	IncludeLocals("GetRandom")
	IncludeLocals("TriggerFix")
	IncludeLocals("FrameworkWrapperLight")
	IncludeLocals("GetCirclePosition")
	IncludeLocals("GetAngleBetween")
	IncludeLocals("CopyTable")
	IncludeLocals("EntityIDChangedHelper")
	IncludeLocals("GetDistance")
	IncludeLocals("IsEntityOfType")
	IncludeLocals("IsValidPosition")
	IncludeLocals("LuaObject")
	IncludeLocals("TargetFilter")
	IncludeLocals("UnlimitedArmy")
	IncludeLocals("UnlimitedArmySpawnGenerator")
	
	IncludeLocals("RuinMod")
	
	IncludeLocals("army_kadircamp")
	IncludeLocals("army_attackers")
	IncludeLocals("army_attackers2")
	IncludeLocals("army_cityDefense")
	IncludeLocals("army_finalAttack")
	IncludeLocals("army_firstAttack")
	IncludeLocals("army_mirai")
	
	IncludeLocals("PoisenReiter")

	IncludeLocals("briefing_attackers")
	IncludeLocals("briefing_attackersGone")
	IncludeLocals("briefing_defend")
	IncludeLocals("briefing_finalAttack")
	IncludeLocals("briefing_mirai")
	IncludeLocals("briefing_prelude")
	IncludeLocals("briefing_riflemen")
	IncludeLocals("briefing_thief")
	IncludeLocals("briefingArchitekt")
	
	IncludeLocals("InteractiveObjects")

	IncludeLocals("gameControl")

	IncludeLocals("player_2")
	IncludeLocals("player_4")
	IncludeLocals("player_5")

	IncludeLocals("quest_buildUp")
	IncludeLocals("quest_defend")
	IncludeLocals("quest_finalAttack")
	IncludeLocals("quest_firstAttackersWave")
	IncludeLocals("quest_mirai")
	IncludeLocals("quest_rescueCity")
	--AnSu: Needed to update the QuestInformation
	IncludeLocals("quest_killFirstAttackers")
	
	IncludeLocals("Towerlimit")
	IncludeLocals("TradeBalancer")
	
	HistoryFlag = GoldHistoryCheck()
	
	Score.Player[0] = {buildings=0, all=0}
	
	math.randomseed(math.mod(XGUIEng.GetSystemTime(),10)*10000000)
	
	TradeBlancerInit()
	ActivateTowerLimit(12)

	LocalMusic.UseSet = MEDITERANEANMUSIC
        
	-- String
	String.Init("CM02_03_BigCity")
	
	Cutscenes = {}
	Cutscenes[INTROCUTSCENE] = "INTRO"	
	Cutscenes[THRESHOLDONECUTSCENE] = "CITY"
	Cutscenes[THRESHOLTWOCUTSCENE] = "FOG"
	Cutscenes[MISSIONCOMPLETECUTSCENE] = "LEAVING"
	
			
	IncludeLocals("Cutscene_" .. Cutscenes[INTROCUTSCENE])
	IncludeLocals("Cutscene_" .. Cutscenes[THRESHOLDONECUTSCENE])	
	IncludeLocals("Cutscene_" .. Cutscenes[THRESHOLTWOCUTSCENE])	
	IncludeLocals("Cutscene_" .. Cutscenes[MISSIONCOMPLETECUTSCENE])
	
	reloadTextFunc = function()
		IncludeLocals("BriefingTable")
	end
	AddMapStartAndSaveLoadedCallback(reloadTextFunc)
	TriggerFix.AllScriptsLoaded()
	-- cutscene
--	StartCutscene("Intro",start1stChapter)

	CreateWoodPile( "holzstapel", 1000000 )

	function
	LocalMusic.CallbackSettlerKilled(_HurterPlayerID, _HurtPlayerID)
	
	local PlayerID = GUI.GetPlayerID()
	
	if _HurterPlayerID ~= _HurtPlayerID and PlayerID == _HurtPlayerID  then		
			if LocalMusic.LastBattleMusicStarted < Logic.GetTime() then					
				if Logic.IsEntityInCategory(_HurterPlayerID,EntityCategories.EvilLeader) == 1 then
					LocalMusic.BattlesOnTheMap = 2
				else
					LocalMusic.BattlesOnTheMap = 1
				end
				LocalMusic.LastBattleMusicStarted = Logic.GetTime() + 127
				LocalMusic.SongLength = 0
			end
		end
	end
	
	StartSpeech = function(_key)

		if _key ~= nil then

			local tablePos = string.find(_key, "/")
			if tablePos ~= nil then
				Stream.Start("Voice\\"..string.sub(_key, 1, tablePos-1).."\\"..string.sub(_key, tablePos + 1, -1)..".mp3", 150)
			else
				if BriefingsVoices[_key][2] then
					Stream.Start(Folders.Map.."voices/"..BriefingsVoices[_key][1]..".mp3", BriefingsVoices[_key][2])
				else
					Stream.Start("Voice\\CM02_03_BigCity\\"..BriefingsVoices[_key][1]..".mp3", 150)
				end
			end
		end

	end

	Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED,nil,"SmokeComeback",1,nil,nil)
	
	
	buildNormal()
	CalcPostitions()
	
	Logic.SetPlayerPaysLeaderFlag(1, 0)
	StartCutscene(Cutscenes[INTROCUTSCENE],CreateBriefingPrelude)

end

function openChest()
	Message("Ihr habt eine Schatztruhe von Kadir gefunden! @cr Darin waren 5.000 Stück Eisen!")
	Logic.AddToPlayersGlobalResource(1,ResourceType.IronRaw,5000)
end

function SmokeComeback()
	local entid = Event.GetEntityID() 
	local enttype = Logic.GetEntityType(entid)
	local entname = Logic.GetEntityName(entid)
	if enttype == Entities.XD_BlendingFog then
		local FogPos = GetPosition(entid)
		Logic.CreateEntity(enttype, FogPos.X, FogPos.Y, 0, 0)
		Logic.SetEntityName(entid,entname)
	end
	return false
end

function GoldHistoryCheck()
	if XNetwork.Manager_IsNATReady then
		return true
	else
		return false
	end
end

function CreateWoodPile( _posEntity, _resources )
    assert( type( _posEntity ) == "string" )
    assert( type( _resources ) == "number" )
    gvWoodPiles = gvWoodPiles or {
        JobID = StartSimpleJob("ControlWoodPiles"),
    }
    local pos = GetPosition( _posEntity )
    local pile_id = Logic.CreateEntity( Entities.XD_Rock3, pos.X, pos.Y, 0, 0 )

    SetEntityName( pile_id, _posEntity.."_WoodPile" )

    local newE = ReplaceEntity( _posEntity, Entities.XD_ResourceTree )
    Logic.SetModelAndAnimSet(newE, Models.XD_SignalFire1)
    Logic.SetResourceDoodadGoodAmount( GetEntityId( _posEntity ), _resources*10 )
    Logic.SetModelAndAnimSet(pile_id, Models.Effects_XF_ChopTree)
    table.insert( gvWoodPiles, { ResourceEntity = _posEntity, PileEntity = _posEntity.."_WoodPile", ResourceLimit = _resources*9 } )
end

function ControlWoodPiles()
    for i = table.getn( gvWoodPiles ),1,-1 do
        if Logic.GetResourceDoodadGoodAmount( GetEntityId( gvWoodPiles[i].ResourceEntity ) ) <= gvWoodPiles[i].ResourceLimit then
            DestroyWoodPile( gvWoodPiles[i], i )
        end
    end
end

function DestroyWoodPile( _piletable, _index )
    local pos = GetPosition( _piletable.ResourceEntity )
    DestroyEntity( _piletable.ResourceEntity )
    DestroyEntity( _piletable.PileEntity )
    Logic.CreateEffect( GGL_Effects.FXCrushBuilding, pos.X, pos.Y, 0 )
    table.remove( gvWoodPiles, _index )
end